package com.hero.objects.powers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class FlashDefense extends SenseAffectingPower {

	private static String xmlID = "FLASHDEFENSE";

	public FlashDefense(Element root) {
		super(root, FlashDefense.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = "";
		ArrayList<String> groups = new ArrayList<String>();
		ArrayList<String> senses = new ArrayList<String>();
		ArrayList<Sense> allSenses = Sense.getAllSenses();
		String group = getSelectedOption().getAlias();
		if (group.toUpperCase().indexOf("GROUP") > 0) {
			group = group.substring(0, group.toUpperCase().indexOf("GROUP"))
					.trim();
		}
		groups.add(group);
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("ADDITIONAL_GROUP")) {
				ad.setDisplayInString(false);
				group = ad.getSelectedOption().getAlias();
				if (group.toUpperCase().indexOf("GROUP") > 0) {
					group = group.substring(0,
							group.toUpperCase().indexOf("GROUP")).trim();
				}
				groups.add(group);
			} else if (ad.getXMLID().endsWith("GROUP")) {
				ad.setDisplayInString(false);
				group = ad.getAlias();
				if (group.toUpperCase().indexOf("GROUP") > 0) {
					group = group.substring(0,
							group.toUpperCase().indexOf("GROUP")).trim();
				}
				groups.add(group);
			} else if (ad.getXMLID().equals("ADDITIONAL_SENSE")) {
				ad.setDisplayInString(false);
				String sense = ad.getSelectedOption().getAlias();
				senses.add(sense);
			} else if (GenericObject.findObjectByID(allSenses, ad.getXMLID()) != null) {
				ad.setDisplayInString(false);
				String sense = ad.getAlias();
				senses.add(sense);
			}
		}

		for (int i = 0; i < groups.size(); i++) {
			if ((i > 0) && (i < groups.size() - 1)) {
				ret += ", ";
			} else if ((i == groups.size() - 1) && (i > 0)) {
				ret += " and ";
			}
			ret += groups.get(i);
		}
		if (groups.size() > 1) {
			ret += " Groups";
		} else {
			ret += " Group";
		}
		for (int i = 0; i < senses.size(); i++) {
			if (i < senses.size() - 1) {
				ret += ", ";
			} else {
				ret += " and ";
			}
			ret += senses.get(i);
		}
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		ret += " " + getAlias();
		ret += " " + getDamageDisplay();
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		String adderString = getAdderString();
		if (adderString.trim().length() > 0) {
			ret += ", " + adderString;
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		int num = (int) Rounder.roundDown(getLevels() / getLevelValue());
		String ret = "(" + num + " points)";
		if (num > 1) {
			return ret;
		} else {
			return "";
		}
	}
}